package com.tyoma.familyMap;

import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;
import java.io.*;

public class FamilyServlet extends HttpServlet {
    
    public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws javax.servlet.ServletException, java.io.IOException {
        
        MetaData metaData = new MetaData(request);
        metaData.calculateAll(this.getServletContext());
        StringBuffer output = metaData.getXmlHeader();
        Hashes hashes = FileToHash.getHashFamilyMap(metaData);
        new HashToXML(hashes).getFamilyMap(metaData.outputMeta,output);
        String printer = output.toString();
        response.setContentType("text/"+ metaData.mode +"; charset=" + metaData.htmlEncode);
        response.setHeader("Content-Language", metaData.lang);
        java.io.PrintWriter out = response.getWriter();
        if (metaData.mode.equals("html")) {
            metaData.printHtml(printer, out);
        }
        else {
            out.print(printer);
        }
        out.close();
    }   
}
