package com.tyoma.familyMap;
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import java.net.URL;

class MetaData {
    String mode = null;
    String lang = null;
    String encode = null;
    String browser = null;
    String login = null;
    String key = null;
    String htmlEncode = null;
    String host = null;
    int port;
    String fileName = null;
    String outputMeta = null;
    HttpServletRequest request = null;
    
    MetaData(HttpServletRequest request) {
        this.request = request;
        mode = getRequestField("mode");
        lang = getRequestField("lang");
        encode = getRequestField("encode");
        browser = getRequestField("browser");
        login = getRequestField("login");
        key = getRequestField("key");
        if (key != null) {
            if (!key.startsWith("@I") || !key.endsWith("@")) {
            try {key = "@I" + Integer.parseInt(key) + '@';}
            catch (NumberFormatException nfe) { key = null; }
            }
        }
        htmlEncode = getRequestField("htmlEncode");
        host = request.getServerName();
        port = request.getServerPort();
    };
    
    String getRequestField(String x){
        String y = null;
        if (request.getParameter(x) != null && request.getParameter(x).trim().length() > 0)
            y = request.getParameter(x);
        return y;
    }
    
    void prepareOutputMeta() {
        String ret = "";
        if (mode != null) ret += " mode='" + mode + "' ";
        if (lang != null) ret += " lang='" + lang + "' ";
        if (encode != null) ret += " encode='" + encode + "' ";
        if (browser != null) ret += " browser='" + browser + "' ";
        if (login != null) ret += " login='" + login + "' ";
        if (key != null) ret += " key='" + key + "' ";
        if (htmlEncode != null) ret += " htmlEncode='" + htmlEncode + "' ";
        outputMeta = ret;
    }
    void calculateAll(ServletContext context) {
        adjustBrowser();
        prepareOutputMeta();
        adjustMode();
        adustLogin();
        setFileName(context);
        String tempLang = guessEncoding();
        adjustLang(tempLang);
        setHtmlEncode();
    }
    void adjustMode() {
        if (mode == null) mode = "xml";
    }
    void adustLogin() {
        if (login == null) login = "tyoma";
    }
    
    void setFileName(ServletContext context) {
        String document_home = "http://" + host + ":" + port;
        String data_path = context.getRealPath("/WEB-INF/data");
        File datadir = new File(data_path);
        fileName = data_path + "/tyoma.GED";
        String[] dir = datadir.list();
        for (int i=0; i < dir.length; i++)
            if  (dir[i].indexOf(login + ".")==0) fileName = data_path + "/" + dir[i];
    }
    String guessEncoding() {
        byte[] sample = null;
        int scope =0;
        String tempLang = "none";
        
        try {
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader file = new InputStreamReader(fis, "ISO-8859-1");
            BufferedReader buff = new BufferedReader(file);
            boolean eof = false;
            int namecount = 0;
            while (!eof) {
                String line = buff.readLine();
                if (line == null)
                    eof = true;
                else if (line.indexOf("1 CHAR") == 0) {
                    encode=line.substring(7);
                }
                else if (line.indexOf("1 NAME") == 0 && line.length() > 13) {
                    namecount++;
                    if (namecount > 3 ) {
                        sample = line.substring(7).getBytes("ISO-8859-1");
                        for (int i=0; i < sample.length; i++) {
                            scope+= (sample[i] & 128) * 2 - 1;
                        }
                        eof = true;
                    }
                }
            }
            buff.close();
            if (encode.equals("ISO-8859-1") || scope < 0) {
                tempLang = "en";
                encode="ISO-8859-1";
            }
            else {
                tempLang = "ru";
                if (encode.startsWith("ANSI") && scope >0 ) {encode = "windows-1251";}
                else {encode = "ISO-8859-5";}
            }
        } catch (IOException e) {}
        return tempLang;
    }
    
    void adjustLang(String tempLang) {
        if (lang==null) {
            if (!tempLang.equals("none")) {lang = tempLang;}
            else {lang = "en";}
        }
    }
    void adjustBrowser() {
        if (browser == null) {
            String userAgent = request.getHeader("User-Agent");
            if (userAgent.indexOf("MSIE") > -1) browser = "MSIE";
        }
    }
    void setHtmlEncode() {
        htmlEncode = encode;
        if (lang.equals("ru") && encode.equals("ISO-8859-1")) htmlEncode = "windows-1251";
    }
    StringBuffer getXmlHeader() {
        StringBuffer output = new StringBuffer(4000);
        output.append("<?xml version=\"1.0\" encoding=\"");
        output.append(encode);
        output.append("\" ?>\n");
        output.append("<?xml-stylesheet type=\"text/xsl\" href=\"http://");
        output.append(host);
        output.append(":");
        output.append(port);
        output.append("/familyMap/xsl/pers_");
        output.append(lang);
        output.append(".xsl\"?>\n");
        // Locale locale = new Locale("ru", "");
        //output.append("<!--DOCTYPE PERSON SYSTEM \""+document_home+"/scripts/family/person.dtd\"-->");
        return output;
    }
    void printHtml(String printer, java.io.PrintWriter out) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            String inputXSL = "http://" + host + ":" + port +
            "/familyMap/xsl/pers_" + lang + ".xsl";
            Source stylesheet = new StreamSource(new URL(inputXSL).openStream());
            Transformer transformer = tFactory.newTransformer(stylesheet);
            //if (lang.equals("ru")) transformer.setOutputProperty("encoding", "windows-1251");
            Source xmlSource2 = new StreamSource(new StringReader(printer));
            transformer.transform(xmlSource2, new StreamResult(out));
        }
        catch (Exception e) {
            out.write(e.getMessage());
            e.printStackTrace(out);
        }
    }
}
