<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

<xsl:template match="/|resumes|resume|location|date|from|to"><xsl:apply-templates/></xsl:template>

<xsl:template match="/" >
<html>
<body>
<form>
<textarea cols="80" rows="35">
<xsl:apply-templates/>
</textarea>
</form>
</body>
</html>
</xsl:template>

<xsl:template match="header">
    <xsl:apply-templates select="name" />
    <xsl:apply-templates select="birth"/>
    <xsl:apply-templates select="../misc" mode="header"/>
    <xsl:apply-templates select="address"/>
    <xsl:apply-templates select="contact"/>
</xsl:template>

<xsl:template match="name">
<xsl:text>		    </xsl:text><xsl:value-of select="title"/> 
    <xsl:text> </xsl:text>
    <xsl:value-of select="firstname"/> 
    <xsl:text> </xsl:text>
    <xsl:value-of select="surname"/>
</xsl:template>

<xsl:template match="birth">
Born:	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="dayOfMonth|month"><xsl:value-of select="."/>.</xsl:template>

<xsl:template match="city|country|state">, <xsl:value-of select="."/></xsl:template>

<xsl:template match="year"><xsl:value-of select="."/></xsl:template>

<xsl:template match="misc" mode="header">
    <xsl:apply-templates mode="header"/>
</xsl:template>

<xsl:template match="para" mode="header"><xsl:if test="not(url)">
<xsl:value-of select="emphasis"/>:<xsl:value-of select="text()"/>
</xsl:if>
</xsl:template>

<xsl:template match="contact">
    <xsl:apply-templates mode="header"/>
</xsl:template>

<xsl:template match="email" mode="header">E-mail:	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="url" mode="header">Web:	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="fax" mode="header">Fax:	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="phone" mode="header">
<xsl:value-of select="@location"/>:	<xsl:value-of select="."/>
</xsl:template>

<xsl:template  match="address">mail:	<xsl:value-of select="street"/>, 
<xsl:value-of select="zip"/><xsl:text> </xsl:text> <xsl:value-of select="city"/>, <xsl:value-of select="country"/>
</xsl:template>

<xsl:template match="objective/para">
Objective:	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="skillarea[position()=1]">
<xsl:value-of select="title"/>:	 <xsl:apply-templates select="skillset" mode="headlines"/>
</xsl:template>

<xsl:template match="skillset" mode="headlines" >
<xsl:apply-templates mode="headlines"/>
</xsl:template>

<xsl:template match="skill" mode="headlines" >* <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="skillarea">
<xsl:value-of select="title"/>:  
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="skillset">
<xsl:value-of select="title"/>:
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="skill"><xsl:value-of select="."/>, </xsl:template>

<xsl:template match="skill[position()=last()]"><xsl:value-of select="."/>;
</xsl:template>

<xsl:template match="skill[position()=last()-1]"><xsl:value-of select="."/> and </xsl:template>

<xsl:template match="skillset[position()=last()]/skill[position()=last()]"><xsl:value-of select="."/>. 
</xsl:template>

<xsl:template match="history">
<xsl:text>
</xsl:text>
<xsl:value-of select="@targets"/>: 
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="job">
<xsl:apply-templates select="employer"/>
<xsl:apply-templates select="location"/>
<xsl:apply-templates select="period"/>
<xsl:apply-templates select="date" mode="job" />
<xsl:apply-templates select="employer/emphasis" mode="company_desc"/>
<xsl:value-of select="jobtitle"/>
<xsl:text>
</xsl:text>
<xsl:apply-templates select="achievements"/>
<xsl:apply-templates select="projects"/>
</xsl:template>

<xsl:template match="employer">
<xsl:text>
</xsl:text>
<xsl:value-of select="citation"/>
</xsl:template>

<xsl:template match="period">
<xsl:text>	</xsl:text>
<xsl:apply-templates select="from"/> - <xsl:apply-templates select="to"/>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template  match="present">present</xsl:template>

<xsl:template match="date" mode="job">
<xsl:text>	</xsl:text>
<xsl:apply-templates />
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="emphasis" mode="company_desc">
<xsl:value-of select="."/>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="achievements">
<xsl:value-of select="achievement"/>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="projects">
<xsl:apply-templates/>
</xsl:template>

<xsl:template  match="project">* <xsl:value-of select="text()"/><xsl:if test="citation"> (<xsl:apply-templates select="citation" mode="project" /> )</xsl:if>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="citation" mode="project"><xsl:value-of select="."/>, </xsl:template>

<xsl:template match="citation[position()=last()]" mode="project"><xsl:value-of select="."/></xsl:template>

<xsl:template match="citation[position()=last()-1]" mode="project"><xsl:value-of select="."/> and </xsl:template>

<xsl:template match="academics">
Education: 
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="degrees">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="degree">
<xsl:value-of select="level"/>
<xsl:text> </xsl:text>
 <xsl:value-of select="institution"/> (<xsl:value-of select="major"/> )<xsl:value-of select="date/year"/>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="interests">
<xsl:text>
</xsl:text>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="interest">
<xsl:value-of select="title"/>:<xsl:text> </xsl:text>
<xsl:apply-templates select="description/para" mode="interest" />
</xsl:template>

<xsl:template match="para" mode="interest">
<xsl:value-of select="text()"/><xsl:apply-templates />,</xsl:template>

<xsl:template match="para[position()=last()]"  mode="interest">
<xsl:value-of select="text()"/><xsl:apply-templates />.
</xsl:template>

<xsl:template match="link"><xsl:value-of select="."/></xsl:template>

<xsl:template match="text()"></xsl:template>

</xsl:stylesheet>